<?php
   // image_counter.php
  
function CounterImage() {
  
   $countLogFile = "/var/tmp/.image_counter_log";
   
   /* Windows users must modify this to suit their environment; e.g. "C:\TEMP\ImageCOunterLog.txt" */ 

   if (file_exists($countLogFile) == true) {
      if (($fp = fopen($countLogFile, "r+")) == false) {
         printf("fopen of the file %s failed\n", $countLogFile);
         exit;
      }
  
      if (($content = fread($fp, filesize($countLogFile))) == false) {
         printf("fread failed on the file %s\n", $countLogFile);
         exit;
      } else {
         if (($imageLocation = ConvertToImage($content)) == false) {
            printf("ConvertToImage failed\n");
            exit;
         } else {
            $content++;
            if (rewind($fp) == 0) {
               printf("rewind failed\n");
               exit;
            }
            if (!fwrite($fp, $content, strlen($content))) {
               printf("fwrite failed while updating count in the file %s\n",
                            $countLogFile);
               exit;
            }
            return $imageLocation;
         }
      }
   } else {
      if (($fp =  fopen($countLogFile, "w")) == false) {
         printf("fopen of the file %s failed\n", $countLogFile);
         exit;
      }
      if (!fwrite($fp, "1", 1)) {
         printf("fwrite failed on the file %s\n", $countLogFile);
         exit;
      }
   }
}
function ConvertToImage($content) {
   $imageFile = "/usr/local/apache/htdocs/images/counter.gif";

   /*Windows users must modify this to suit their environment; e.g.
          C:\TEMP\COUNTER.GIF */
   $relativePath =  "images/counter.gif";
   $noOfChars = strlen($content);

   $charHeight = ImageFontHeight(5);
   $charWidth = ImageFontWidth(5);
   $strWidth = $charWidth * $noOfChars;
   $strHeight = $charHeight;
  
   $imgWidth = $strWidth + 15;
   $imgHeight = $strHeight + 15;
   $imgCenterX = $imgWidth / 2;
   $imgCenterY = $imgHeight / 2;
 
   $im = ImageCreate($imgWidth, $imgHeight);
   $black = ImageColorAllocate($im, 0, 0, 0);
   $red   = ImageColorAllocate($im, 255, 0, 0);
   ImageFilledRectangle($im, 0, 0, $imgWidth, $imgHeight, $black);
   ImageFilledRectangle($im, 3, 3, $imgWidth-4, $imgHeight-4, $red);
  
   $drawPosX = $imgCenterX - ($strWidth / 2) + 1;
   $drawPosY = $imgCenterY - ($strHeight / 2);
   ImageString($im, 5, $drawPosX, $drawPosY, $content, $black);
 
   ImageGif($im, $imageFile);
   return $relativePath;
   }
?>